# lowercase - System Dictation Replacement for macOS

A native macOS app that takes over your system dictation key for offline speech-to-text transcription using NVIDIA's Parakeet TDT model via [FluidAudio](https://github.com/FluidInference/FluidAudio).

## 🚀 Quick Build & Deploy

### Regular Build (for testing)

```bash
./build-and-deploy.sh
```

Builds app, creates DMG, deploys to maxawad.com/public

### Notarized Build (for distribution)

```bash
./notarize-and-deploy.sh
```

**What it does:**
1. ✅ Builds lowercase.app (Debug config, properly signed)
2. 🔐 Notarizes with Apple (~2-5 min wait)
3. 📎 Staples approval ticket to app
4. 📦 Creates compressed DMG installer
5. 🚀 Deploys to `maxawad.com/public`

**Benefits:**
- ✅ No "Unknown Developer" warnings
- ✅ Works from ANY URL (maxawad.com, gdrive, email, etc.)
- ✅ Shows as "Identified Developer"
- ✅ Professional distribution

**Download link:** https://maxawad.com/lowercase.dmg

**One-time setup:**
```bash
xcrun notarytool store-credentials "notarytool-profile" \
  --apple-id "your@email.com" \
  --team-id "J497DX6ZF8" \
  --password "app-specific-password"
```
(Get app-specific password from appleid.apple.com)

---

## Features
- **Dictation key takeover**: Press the Dictation key (F5) - app automatically intercepts and replaces system dictation
- **Offline transcription**: Using Parakeet TDT 0.6B - no internet required
- **Two model options**: V2 English (442MB, fast) or V3 Multilingual (2.4GB, 100+ languages)
- **Auto-paste**: Transcriptions automatically paste into active text field
- **Smart clipboard management**: Optional clipboard save/restore
- **Background mode**: Optional Dock icon hiding - run silently in background
- **Fast & efficient**: Runs on Apple Neural Engine
- Models auto-download on first use (~2.4GB per model)

## Getting Started

1. **Install XcodeGen** (if not already installed)
   ```bash
   brew install xcodegen
   ```

2. **Generate the Xcode project**
   ```bash
   cd experimental/maxawad/macOS/speech-to-text
   xcodegen
   ```

3. **Open and run**
   - Open `Dictation.xcodeproj` in Xcode
   - Wait for Swift Package Manager to resolve FluidAudio
   - Build and run (⌘R)

4. **Grant permissions** (required)
   - Accessibility: System Settings → Privacy & Security → Accessibility → Enable lowercase
   - Input Monitoring: System Settings → Privacy & Security → Input Monitoring → Enable lowercase
   - Microphone: Will prompt automatically on first use

## Usage

**Just press the Dictation key!**

1. **Start recording**: Press Dictation key (F5, microphone icon between Spotlight and DND)
2. **Speak**: The app is now recording...
3. **Stop**: Press Dictation key again
4. **Done**: Text automatically pastes into your active text field! ✨

The app runs in the background and automatically takes over your system dictation key. No setup required - just press the key and start speaking!

## Settings

- **Restore clipboard after pasting**: Saves your clipboard, pastes transcription, then restores it
- **Show icon in Dock**: Toggle to hide Dock icon and run as background app
- **Model selection**: Choose between V2 English (442MB) or V3 Multilingual (2.4GB, 100+ languages)

## Requirements
- macOS 14.0+
- Xcode 15+
- Apple Silicon Mac (M1 or newer) recommended

## Credits
- [FluidAudio](https://github.com/FluidInference/FluidAudio) by FluidInference
- [NVIDIA Parakeet](https://huggingface.co/nvidia/parakeet-tdt-0.6b-v2) TDT model

